//
//  GSLayerDrawHelper.h
//  Glyphs
//
//  Created by Georg Seifert on 15.05.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSLayer.h>

@class GSPath;

@interface GSLayerDrawHelper : NSObject

@property (nonatomic) CGFloat scale;
@property (nonatomic) CGFloat factor;
@property (nonatomic) BOOL transformedContext;
@property (nonatomic) NSPoint position;
@property (unsafe_unretained, nonatomic) id delegate;
@property (nonatomic) BOOL showNodes;
@property (nonatomic) BOOL showAnchors;
@property (nonatomic) BOOL fillOutline;
@property (nonatomic) BOOL clipToBounds;
@property (nonatomic) BOOL checkSelection;

@property (strong) NSMutableDictionary <NSNumber *, NSBezierPath *> *closedPathCache;
@property (strong) NSMutableDictionary <NSNumber *, NSBezierPath *> *openPathCache;

- (void)drawLayer:(GSLayer *)layer attributes:(NSDictionary *)attributes;

#ifndef GLYPHS_VIEWER
- (void)drawShadowAccents:(GSLayer *)layer;
#endif

- (void)drawMetricsForLayer:(GSLayer *)layer;

#ifndef GLYPHS_LITE
- (void)drawLayerColor:(GSLayer *)layer;

- (void)drawDrawStack:(NSArray *)drawStack;
#endif

- (void)drawPlaceholder:(GSLayer *)layer;

+ (void)drawPlaceholder:(GSLayer *)layer scale:(CGFloat)scale atPoint:(NSPoint)layerOrigin;

+ (void)drawPlaceholder:(GSLayer *)layer scale:(CGFloat)scale inFrame:(NSRect)frame height:(CGFloat)height;

- (CGFloat)computeScaledValue:(NSString *)value;

+ (CGFloat)computeScaledValue:(NSString *)value scale:(CGFloat)scale factor:(CGFloat)factor;

@end
